<?php defined('SYSPATH') or die('No direct script access.');

class Task_Indexer_Email extends Minion_Task {

    protected function _execute(array $params){
        $email_path = APPPATH.'emails.txt';
        $suffix = Task_Helper::getSuffix();

        $regex = '[\d\w-_\.]+(?:\@|\%40)[\d\w-_\.]+\.(?:'.implode('|', $suffix).')';
        $exc = '(?:(^\d+|^\.|^\%|^\w+|^\-|^\&)?)';
        $records = DB::select('c.location', 'l.id', 'l.data', 'l.client_id', DB::expr('extract(epoch FROM l.datetime) AS datetime'))
            ->from(['logpost', 'l'])
            ->join(['clients', 'c'])
            ->on('l.client_id', '=', 'c.id')
            ->where('l.data', '~', $exc.$regex.$exc)
            ->and_where('l.id', '>', Helper::getCounter('email'))
            ->limit(20)
            ->order_by('id', 'asc')
            ->execute()
            ->as_array();

        if(!file_exists($email_path)){
            touch($email_path);
        }

        foreach ($records as $logpost){
            $logpost['data'] = json_decode($logpost['data'], true);
            if(isset($logpost['data']['Cookie']))
                unset($logpost['data']['Cookie']);

            $referer = '';
            if(isset($logpost['data']['Referer'])){
                $referer = $logpost['data']['Referer'];
                unset($logpost['data']['Referer']);
            }

            $logpost['data'] = json_encode($logpost['data']);

            preg_match(
                '#'.$exc.$regex.$exc.'#',
                urldecode($logpost['data']),
                $matches
            );

            $logpost['location'] = Task_Helper::locationToInt($logpost['location']);

            foreach ($matches as $email){
                // TODO urldecode exec up, it need on the down?
                $email = urldecode(preg_replace('#\+#','', $email));
                if($email[0] == 'u'){
                    $email = preg_replace('#u\d{4}#', '', $email);
                }
                if($email[0] == '%'){
                    $email = preg_replace('#\%\d+#', '', $email);
                }
                $email_suffix = preg_replace('#\W+#', '', pathinfo($email, PATHINFO_EXTENSION));
                $email_list = str_replace("\r\n",'', file($email_path));
                if(Valid::email($email) && strlen($email) < 50 && in_array($email_suffix, $suffix) && Model_Insert_Blacklist::checkBlackList($referer, 2)){
                    if(!in_array($email, $email_list)){
                        file_put_contents($email_path, $email."\r\n", FILE_APPEND);
                    }
                    DB::replace('email', ['id', 'client_id', 'datetime', 'location', 'suffix', 'email', 'referer'])
                        ->values([$logpost['id'], $logpost['client_id'], $logpost['datetime'], $logpost['location'], $email_suffix, $email, $referer])
                        ->execute(Helper::getCurrentSphinx());
                }
            }

        }

        if(!empty($records)) {
            /* Update counter */
            $value = end($records);
            Helper::updCounter($value['id'], 'email');
        }
    }
}
